<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Whitelabel_email_template {

    public function __construct()
    {
        $this->ci =& get_instance();

        $this->module_name = 'white_labeler';
        $this->ci->load->library('Email');
        log_message('debug', "Email template initialized");
    }

      function send_whitelabel_domain_email($partners,$data,$email_subj)
    {       

        $whitelabelinfo = $this->ci->session->userdata('white_label_information');
        if(isset($whitelabelinfo['support_email'])){
            $reply_to_email = $whitelabelinfo && isset($whitelabelinfo['support_email']) && $whitelabelinfo['support_email'] ? $whitelabelinfo['support_email'] : SUPER_ADMIN;
        }else{
            $reply_to_email =  isset($data['support_email']) && $data['support_email']? $data['support_email'] : SUPER_ADMIN;       
        }
      


        //Send confirmation email
        $email_data = array (                   
            'partner_name' => $partners['name'],
            'old_partner_domain' => $partners['domain'] ?? null,
            'partner_domain' => $data['domain'] ?? null,       
            'old_support_email' => $partners['support_email'] ?? null,
            'support_email' => $data['support_email'] ?? null,           
            'old_do_not_reply_email' => $partners['do_not_reply_email'] ?? null,  
            'do_not_reply_email' => $data['do_not_reply_email'] ?? null,           
        );

        $this->ci->email->from($reply_to_email);
        $this->ci->email->to('pankaj@minical.io');
        $this->ci->email->cc('linda@minical.io,jaeyun@minical.io');
        $this->ci->email->reply_to($reply_to_email); 
        $this->ci->email->subject($email_subj.' | '.$email_data['partner_name']);
        $this->ci->email->message($this->ci->load->view('../extensions/'.$this->module_name.'/views/Whitelable_html', $email_data, true));
       
         $this->ci->email->send();
    
        // $this->reset_language($company['default_language']);

        return array('success' => true);
    }

    
}